@extends('layouts.base')

@section('title', 'Terms And Condition')


@section('content')
<section class="hero-section">
	<div class="container-fluid mx-5  ">
		<h1>Privacy Policy</h1>
	</div>
</section>
<div class="container-fluid mx-5  my-5">
	<h5><strong>Introduction</strong></h5>
	<p>As part of our daily business operations, we collect personal information from our clients and prospective clients in order to provide them with our products and services, and ensure that we can meet their needs when providing these products and services, as well as when providing them with any respective information.</p>
	<p>Your privacy is of utmost importance to us, and it is our policy to safeguard and respect the confidentiality of information and the privacy of individuals. This Privacy Notice sets out how {{$settings->site_name}} products and services provided in the U.S and all across the globe collects, uses and manages the personal information we receive from you, or a third party, in connection with our provision of services to you or which we collect from your use of our services and/or our website. The Privacy Notice also informs you of your rights with respect to the processing of your personal information.</p><p>Our Privacy Notice is reviewed regularly to ensure that any new obligations and technologies, as well as any changes to our business operations and practices are taken into consideration, as well as that it remains abreast of the changing regulatory environment. Any personal information we hold will be governed by our most recent Privacy Notice.</p>
	<p>Please note that if you are an employee of the Company, a contractor to the Company or a third-party provider, your personal information will be used in connection with your employment contract or your contractual relationship, whichever applies.</p>
	<p>This Privacy Notice applies to the processing activities performed by {{$settings->site_name}} to the personal information of its clients and its potential clients and website visitors.</p>
	<p>We may amend this Privacy Notice at any time by posting the amended version on this site including the effective date of the amended version. We will announce any material changes to this Privacy Notice on our website.</p>
	<h5>Definitions</h5>
	<p>2.1 As used herein, the following terms are defined as follows:</p>
	<p>2.1.1 “Digital Asset” is a digital representation of value (also referred to as “cryptocurrency,” “virtual currency,” “digital currency,” “crypto token,” “crypto asset,” or “digital commodity”), such as bitcoin, XRP or ether, which is based on the cryptographic protocol of a computer network that may be (i) centralized or decentralized, (ii) closed or open-source, and (iii) used as a medium of exchange and/or store of value.</p>
	<p>2.1.2 “{{$settings->site_name}} Account” means a user-accessible account offered via the {{$settings->site_name}} services where Digital Assets are stored.</p>
	<p>2.1.3 “We,” and “Us” refers to {{$settings->site_name}}.</p>
	<p>2.1.4 “Personal Information” or “Personal Data” or “your data” refers to any information relating to you, as an identified or identifiable natural person, including your name, an identification number, location data, or an online identifier or to one or more factors specific to the physical, economic, cultural or social identity of you as a natural person.</p>
	<h5>Your Data Controller</h5>
	<p>We are responsible for the collection, use, disclosure, retention and protection of your personal information in accordance with our global privacy standards, this Privacy Notice, as well as any applicable national laws. We use encryption to protect your information and store decryption keys in separate systems. We process and retain your personal information on our servers in multiple data center locations, including the European Union, Japan, Singapore, the United States of America and elsewhere in the world.</p>
	<h5>How do we protect personal information?</h5>
	<p>We respect the privacy of any users who access our website, and we are therefore committed to taking all reasonable steps to safeguard any existing or prospective clients, applicants and website visitors.</p>
	<p>We keep any personal data of our clients and potential clients in accordance with the applicable privacy and data protection laws and regulations.</p>
	<p>We have the necessary and appropriate technical and organizational measures and procedures in place to ensure that your information remains secure at all times. We regularly train and raise awareness for all our employees to the importance of maintaining, safeguarding and respecting your personal information and privacy. We regard breaches of individuals’ privacy very seriously and will impose appropriate disciplinary measures, including dismissal from employment. We have also appointed a Group Data Protection Officer, to ensure that our Company manages and processes your personal information in compliance with the applicable privacy and data protection laws and regulations, and in accordance with this Privacy Notice.</p>
	<p>The personal information that you provide us with when applying to open an account, applying for a role within the Company, or when using our website, is classified as registered information, which is protected in several ways. You can access your registered information after logging in to your account by entering your username and the password that you have selected. It is your responsibility to make sure that your password is only known to you and not disclosed to anyone else. Registered information is securely stored in a safe location, and only authorised personnel have access to it via a username and password. All personal information is transferred to the Company over a secure connection, and thus all reasonable measures are taken to prevent unauthorised parties from viewing any such information. Personal information provided to the Company that does not classify as registered information is also kept in a safe environment and accessible by authorised personnel only through username and password.</p>
	<h5>Information we may collect about you</h5>
	<p>In order to open an account with us, you must first complete and submit a “create account” form to us by completing the required information. By completing this form, you are requested to disclose personal information in order to enable us to assess your application and comply with the relevant laws (including their regulations).</p>
	<p>The information that we collect from you is as follows:</p>
	<p>Full name, residential address and contact details (e.g. email address, telephone number, fax etc.);</p><p>Date of birth, place of birth, gender, citizenship;</p>
	<p>Bank account information, credit card details, including details about your source of funds, assets and liabilities, and OFAC information;</p>
	<p>Trading account balances, trading activity, your inquiries and our responses;</p>
	<p>Information on whether you hold a prominent public function (PEP);</p>
	<p>Verification information, which includes information necessary to verify your identity such as a passport, driver’s licence or Government-issued identity card);</p>
	<p>Other Personal Information or commercial and/or identification information – Whatever information we, in our sole discretion, deem necessary to comply with our legal obligations under various anti-money laundering (AML) obligations, such as under the European Union’s 4th AML Directive and the U.S. Bank Secrecy Act (BSA).</p>
	<p>Information we collect about you automatically.</p>
	<p>Location Information – Information that is automatically collected via analytics systems providers to determine your location, including your IP address and/or domain name and any external page that referred you to us, your login information, browser type and version, time zone setting, browser plug-in types and versions, operating system, and platform;</p>
	<p>Log Information – Information that is generated by your use of Kraken Exchange Services that is automatically collected and stored in our server logs. This may include, but is not limited to, device-specific information, location information, system activity and any internal and external information related to pages that you visit, including the full Uniform Resource Locators (URL) clickstream to, through and from our Website or App (including date and time; page response times, download errors, length of visits to certain pages, page interaction information (such as scrolling, clicks, and mouse-overs), and methods used to browse away from the page;</p>
	<p>Information we receive about you from other sources.</p>
	<p>We obtain information about you in a number of ways through your use of our services, including through any of our websites, the account opening process, webinar sign-up forms, event subscribing, news and updates subscribing, and from information provided in the course of on-going support service communications. We also receive information about you from third parties such as your payment providers and through publicly available sources. For example:</p>
	<p>The banks you use to transfer money to us will provide us with your basic personal information, such as your name and address, as well as your financial information such as your bank account details;</p>
	<p>Your business partners may provide us with your name and address, as well as financial information;</p><p>Advertising networks, analytics providers and search information providers may provide us with anonymized or de-identified information about you, such as confirming how you found our website;</p>
	<p>Credit reference agencies do not provide us with any personal information about you, but may be used to corroborate the information you have provided to us.</p>
	<h5>General Provisions</h5>
	<p>Personal Information you provide during the account creation process will be retained for one year, even if your registration is incomplete or abandoned.</p>
	<h5>Lawful basis for processing your personal information</h5>
	<p>We will process your personal information on the following bases and for the following purposes:</p>
	<h5>Performance of a contract</h5>
	<p>We process personal data in order to provide our services and products, as well as information regarding our products and services based on the contractual relationship with our clients (i.e. so as to perform our contractual obligations). In addition, the processing of personal data takes place to enable the completion of our client on-boarding process.</p>
	<p>In view of the above, we must verify your identity in order to accept you as our client and we will use your personal data in order to effectively manage your trading account with us. This may include third parties carrying out credit or identity checks on our behalf. The use of your personal information is necessary for us to know who you are, as we have a legal obligation to comply with “Know Your Customer” and customer due diligence regulatory obligations.</p><p>Compliance with a legal obligation</p>
	<p>There are a number of legal obligations imposed by relevant laws to which we are subject, as well as specific statutory requirements e.g. anti-money laundering laws, financial services laws, corporation laws, privacy laws and tax laws. There are also various supervisory authorities whose laws and regulations apply to us. Such obligations and requirements imposed on us necessary personal data processing activities for identity verification, payment processing, compliance with court orders, tax laws or other reporting obligations and anti-money laundering controls.</p>
	<p>These obligations apply at various times, including client on-boarding, payments and systemic checks for risk management.</p><p>For the purpose of safeguarding legitimate interests</p>
	<p>We process personal data so as to safeguard the legitimate interests pursued by us or by a third party. A legitimate interest is when we have a business or commercial reason to use your information. Example of such processing activities include the following:</p><p>Initiating legal claims and preparing our defense in litigation procedures;</p>
	<p>Means and processes we undertake to provide for the Company’s IT and system security, preventing potential crime, asset security and access controls;</p>
	<p>Measures for managing the business and for further developing products and services;</p>
	<p>Sharing your data within the Payward Inc. group of companies for the purpose of updating and/or verifying your personal data in accordance with the relevant anti-money laundering compliance frameworks, and</p>
	<h5>Risk management.</h5>
	<p>To provide you with products and services, or information about our products and services, and to review your ongoing needs.</p>
	<p>Once you successfully open an account with us, or subscribe to information, we must use your personal information to perform our services and comply with our obligations to you. It is also in our legitimate interests to try to ensure that we are providing the best products and services so we may periodically review your needs based on our assessment of your personal information to ensure that you are getting the benefit of the best possible products and services from us.</p>
	<p>To help us improve our products and services, including support services, and develop and market new products and services.</p>
	<p>We may, from time-to-time, use personal information provided by you through your use of the services and/or through client surveys to help us improve our products and services. It is in our legitimate interests to use your personal information in this way to try to ensure the highest standards when providing you with our products and services and to continue to be a market leader within the cryptocurrency financial service industry.</p>
	<h5>To investigate or settle enquiries or disputes</h5>
	<p>We may need to use personal information collected from you to investigate issues or to settle disputes with you because it is our legitimate interest to ensure that issues and disputes get investigated and resolved in a timely and efficient manner.</p>
	<p>To comply with applicable laws, subpoenas, court orders, other judicial process, or the requirements of any applicable regulatory authorities</p><p>We may need to use your personal information to comply with any applicable laws and regulations, subpoenas, court orders or other judicial processes, or requirements of any applicable regulatory authority. We do this not only to comply with our legal obligations but because it may also be in our legitimate interest to do so.</p>
	<h5>To send you surveys</h5>
	<p>From time to time, we may send you surveys as part of our client feedback process. It is in our legitimate interest to ask for such feedback to try to ensure that we provide our products and services at the highest standard. However, we may from time to time also ask you to participate in other surveys and if you agree to participate in such surveys we rely on your consent to use the personal information we collect as part of such surveys. All responses to any survey we send out whether for client feedback or otherwise will be aggregated and depersonalised before the results are published and shared.</p>
	<h5>Data analysis</h5>
	<p>Our website pages and emails may contain web beacons or pixel tags or any other similar types of data analysis tools that allow us to track receipt of correspondence and count the number of users that have visited our webpage or opened our correspondence. We may aggregate your personal information with the personal information of our other clients on an anonymous basis (that is, with your personal identifiers removed), so that more rigorous statistical analysis of general patterns may lead us to providing better products and services.</p>
	<p>If your personal information is completely anonymised, we do not require a legal basis as the information will no longer constitute personal information. If your personal information is not in an anonymised form, it is in our legitimate interest to continually evaluate that personal information to ensure that the products and services we provide are relevant to the market.</p>
	<h5>Marketing purposes</h5>
	<p>We may use your personal information to send you marketing communications by email or other agreed forms (including social media campaigns), to ensure you are always kept up-to-date with our latest products and services. If we send you marketing communications we will do so based on your consent and registered marketing preferences.</p>
	<p>Internal business purposes and record keeping</h5>
	<p>We may need to process your personal information for internal business and research purposes as well as for record keeping purposes. Such processing is in our own legitimate interests and is required in order to comply with our legal obligations. This may include any communications that we have with you in relation to the products and services we provide to you and our relationship with you. We will also keep records to ensure that you comply with your contractual obligations pursuant to the agreement (‘Terms of Service”) governing our relationship with you.</p>
	<h5>Legal Notifications</h5>
	<p>Often the law requires us to advise you of certain changes to products or services or laws. We may need to inform you of changes to the terms or the features of our products or services. We need to process your personal information to send you these legal notifications. You will continue to receive this information from us even if you choose not to receive direct marketing information from us.</p>
	<h5>Disclosure of your personal information</h5>
	<p>The Company will not disclose any of its clients’ confidential information to a third party, except: (a) to the extent that it is required to do so pursuant to any applicable laws, rules or regulations; (b) if there is a duty to disclose; (c) if our legitimate business interests require disclosure; (d) in line with our Terms of Service; (e) at your request or with your consent or to those described in this Privacy Notice. The Company will endeavour to make such disclosures on a “need-to-know” basis, unless otherwise instructed by a regulatory authority. Under such circumstances, the Company will notify the third party regarding the confidential nature of any such information.</p>
	<p>As part of using your personal information for the purposes set out above, the Company may disclose your personal information to the following:</p>
	<p>Any members of the Company, which means that any of our affiliates and subsidiaries may receive such information;</p>
	<p>Any of our service providers and business partners, for business purposes, such as specialist advisors who have been contracted to provide us with administrative, financial, legal, tax, compliance, insurance, IT, debt-recovery, analytics, research or other services;</p>
	<p>If the Company discloses your personal information to service providers and business partners, in order to perform the services requested by clients, such providers and partners may store your personal information within their own systems in order to comply with their legal and other obligations.</p>
	<p>We require that service providers and business partners who process personal information to acknowledge the confidentiality of this information, undertake to respect any client’s right to privacy and comply with all relevant privacy and data protection laws and this Privacy Notice.</p>
	<h5>Where we store your personal data</h5>
	<p>Our operations are supported by a network of computers, servers, and other infrastructure and information technology, including, but not limited to, third-party service providers. We and our third-party service providers and business partners store and process your personal data in the European Union, Japan, Singapore, and the United States of America.</p>
	<h5>Privacy Shield</h5>
	<p>Payward Ventures. Inc. has self-certified to the U.S. Department of Commerce our adherence to the EU-US Privacy Shield Framework for all personal information received, collected, used, retained and transferred from countries in the European Union and the United Kingdom (UK) to the United States (US) in reliance on the Privacy Shield.Payward Ventures. Inc. has certified to the Department of Commerce that it adheres to the Privacy Shield Principles with respect to such information. If there is any conflict between the terms of this Privacy Notice and the Privacy Shield Principles, the Privacy Principles shall govern.</p>
	<p>To learn more about Privacy Shield, visit the U.S. Department of Commerce Privacy Shield Website at https://www.privacyshield.gov</p>
	<p>Under Privacy Shield, we are responsible for the processing of personal information we receive, collect, use, retain and subsequently transfer to a third party service provider or business partner acting for or on our behalf. We are liable for ensuring that the third parties we engage support our Privacy Shield commitments. The U.S. Federal Trade Commission has regulatory enforcement authority over our processing of personal information received or transferred pursuant to Privacy Shield. Payward Ventures. Inc. commits to cooperate and comply with the advice of the regulatory authorities to whom you may raise a concern about our processing of your personal information pursuant to Privacy Shield, including to the panel established by the EU authorities. This is provided at no cost to you. For more information, see the following Privacy Shield Complaints section below.</p>
</div>


    
@endsection

