@extends('layouts.dasht')
@section('title', $title)
@section('content')
<div class="udex-main" id="main">
	<x-danger-alert />
    <x-success-alert />
    {{-- <script src="https://tradersrite.net/js/validation.js"></script> --}}
    <ul class="breadcrumb shadow-none p-0" style="background-color: transparent">
		<li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
		<li class="breadcrumb-item active">Deposit</li>
	</ul><h1 class="clearfix">Deposit<div class="float-right"></div></h1>
			<div class="bg-white p-4 mt-3 rounded mb-5">
				<h3 class="mb-4">Select Payment method</h3>
				<form method="POST" action="{{route('newdeposit')}}">
					@csrf


                  
                    <div class="input-group mb-3">
						<input type="hidden" name="asset" value=" ">	
                <select class="form-control"  name="payment_method"  required>
                @forelse ($dmethods as $method)
                  <option value="{{$method->name}}">{{$method->name}}</option>
                  @empty
					<option class="">No Payment Method enabled at the moment, please check
						back later.</option>
                        @endforelse
</select>
</div>				
					
					<div class="input-group mb-3">
						<div class="input-group-prepend">
							<span class="input-group-text">{{ $settings->s_currency }}</span>
						</div>
						<input type="number" required name="amount" placeholder="Amount" class="form-control" />
					</div>
					
					
					<button class="btn btn-primary">CONTINUE</button>
				</form>
			</div>
			<h3>Deposit History</h3>
			<div class="table-responsive mt-3">
				<table class="table table-bordered table-hover table-striped bg-white">
               
					<tr class="bg-dark text-light">
						<th style="min-width: 150px">Details</th><th style="min-width: 150px">Method</th><th style="min-width: 120px">Status</th>
					</tr>
					@forelse ($deposits as $deposit)
					<tr>
						<td>
                        
							<div class="font-weight-bold">  {{ number_format($deposit->amount, 2, '.', ',') }}  {{ $settings->s_currency }}</div>
							<date class="text-black-50 small">{{ \Carbon\Carbon::parse($deposit->created_at)->toDayDateTimeString() }}</date></td>
						<td><span class="badge badge-info"><i class="fas fa-university"></i> {{$deposit->payment_mode}}</span></td>
						
                        <td>
                            @if($deposit->status=='Pending')
                            <span class="badge badge-warning">
							<i class="fa fa-check"></i> {{$deposit->status}}</span>
                            @else
                            <span class="badge badge-success">
							<i class="fa fa-check"></i> {{$deposit->status}}</span>
                            @endif
                            </td>
                            <td colspan="3"></td></tr>

                            @empty
					<option class=""> No Deposit History.</option>
                        @endforelse
				</table>
			</div>
@endsection
